/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug.swing;

import frc.emul.api.IAddressBinder;
import frc.emul.vectrex.debug.TraceRecorder;
import frc.emul.vectrex.debug.UITraceEntries;
import frc.emul.vectrex.debug.UITraceEntry;
import frc.emul.vectrex.debug.swing.BackTraceTableModel;
import frc.emul.vectrex.debug.swing.BackTraceTableRenderer;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class UIBackTracer {
    private final UITraceEntries entries = new UITraceEntries();

    public void loadTraces(TraceRecorder traceRecorder) {
        this.entries.loadTrace(traceRecorder);
    }

    public void setAddressBinder(IAddressBinder iAddressBinder) {
        this.entries.setAddressBinder(iAddressBinder);
    }

    public void openFrame(boolean bl) {
        JTable jTable = new JTable(new BackTraceTableModel(this.entries));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JFrame jFrame = new JFrame(bl ? "ParaJVE - Crash BackTrace" : "ParaJVE Back-Trace");
        jTable.setFont(new Font("courier", 0, 12));
        jTable.setDefaultRenderer(Object.class, new BackTraceTableRenderer(this.entries));
        jTable.setAutoResizeMode(2);
        int n = 0;
        while (n < 9) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n + 4);
            int n2 = 20 + 7 * UITraceEntry.getRegisterChars(n);
            tableColumn.setMinWidth(n2);
            tableColumn.setMaxWidth(n2);
            tableColumn.setPreferredWidth(n2);
            tableColumn.setResizable(false);
            ++n;
        }
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        int n3 = 69;
        tableColumn.setPreferredWidth(n3);
        tableColumn = jTable.getColumnModel().getColumn(13);
        n3 = 349;
        tableColumn.setPreferredWidth(n3);
        tableColumn.setMaxWidth(n3);
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof JLabel) {
            ((JLabel)((Object)tableCellRenderer)).setHorizontalAlignment(0);
        }
        jTable.moveColumn(4, 1);
        jTable.moveColumn(13, 0);
        jTable.moveColumn(13, 0);
        jTable.moveColumn(2, 0);
        jTable.moveColumn(12, 3);
        ToolTipManager.sharedInstance().registerComponent(jTable);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(2);
        UIUtils.center(jFrame, null, 0, 0);
        jFrame.setVisible(true);
        if (!bl) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {}
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            } while (jFrame.isVisible());
        }
    }
}

